@extends('layouts.app')
@section('title', 'AI Assistant Dashboard')

@section('content')
<section class="content-header">
  <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">AI Assistant Dashboard</h1>
  <p class="help-block">Manage chats, FAQs, product sync, and report training.</p>
</section>

<section class="content">
  @if(session('status'))
    <div class="alert alert-success">{{ session('status.msg') }}</div>
  @endif

  <div class="nav-tabs-custom">
    <ul class="nav nav-tabs">
      <li class="active"><a href="#tab_chats" data-toggle="tab">Chats</a></li>
      <li><a href="#tab_faqs" data-toggle="tab">FAQs</a></li>
      <li><a href="#tab_products" data-toggle="tab">Products</a></li>
      <li><a href="#tab_reports" data-toggle="tab">Reports</a></li>
    </ul>
    <div class="tab-content">
      <div class="tab-pane active" id="tab_chats">
        <div class="box box-solid">
          <div class="box-header with-border"><h3 class="box-title">Recent AI Chats (last 100)</h3></div>
          <div class="box-body table-responsive no-padding">
            <table class="table table-striped table-bordered">
              <thead>
                <tr>
                  <th>ID</th>
                  <th>User</th>
                  <th>Intent</th>
                  <th>Scope</th>
                  <th>Time</th>
                  <th>Question</th>
                  <th>Answer</th>
                  <th>OK</th>
                  <th>Rating</th>
                  <th>Date</th>
                </tr>
              </thead>
              <tbody>
                @foreach($messages as $m)
                  <tr>
                    <td>{{ $m->id }}</td>
                    <td>
                      @php
                        $u = $m->user;
                        $nm = '';
                        if ($u) {
                          $full = trim(($u->first_name.' '.$u->last_name));
                          $nm = $full !== '' ? $full : ($u->username ?? '');
                        }
                      @endphp
                      {{ $nm !== '' ? $nm : $m->user_id }}
                    </td>
                    <td>{{ $m->intent }}</td>
                    <td>{{ $m->scope }}</td>
                    <td>{{ $m->time_label }}</td>
                    <td style="max-width: 280px; white-space: nowrap; overflow: hidden; text-overflow: ellipsis;" title="{{ $m->question }}">{{ $m->question }}</td>
                    <td style="max-width: 280px; white-space: nowrap; overflow: hidden; text-overflow: ellipsis;" title="{{ $m->answer }}">{{ $m->answer }}</td>
                    <td>{{ $m->ok ? '✔' : '✖' }}</td>
                    <td>{{ $m->rating }}</td>
                    <td>{{ optional($m->created_at)->format('Y-m-d H:i') }}</td>
                  </tr>
                @endforeach
              </tbody>
            </table>
          </div>
          <div class="box-footer">
            <a class="btn btn-primary" href="{{ route('ai.chat') }}" target="_blank">Open Live Chat</a>
          </div>
        </div>
      </div>

      <div class="tab-pane" id="tab_faqs">
        <div class="row">
          <div class="col-md-6">
            <div class="box box-solid">
              <div class="box-header with-border"><h3 class="box-title">Add / Update FAQ</h3></div>
              <form id="faq-form" method="POST" action="{{ route('ai.faq.save') }}">
                @csrf
                <div class="box-body">
                  <div class="form-group">
                    <label>ID</label>
                    <input class="form-control" name="id" id="faq-id" placeholder="unique key (e.g., shipping, returns)" required>
                  </div>
                  <div class="form-group">
                    <label>Patterns (comma or newline separated)</label>
                    <textarea class="form-control" name="patterns" id="faq-patterns" rows="3" placeholder="keywords or phrases to match"></textarea>
                  </div>
                  <div class="form-group">
                    <label>Answer (English)</label>
                    <textarea class="form-control" name="answer" id="faq-answer" rows="3" required></textarea>
                  </div>
                  <div class="form-group">
                    <label>Answer (Tagalog)</label>
                    <textarea class="form-control" name="answer_translations[tl]" id="faq-answer-tl" rows="2"></textarea>
                  </div>
                  <div class="form-group">
                    <label>Answer (Cebuano)</label>
                    <textarea class="form-control" name="answer_translations[ceb]" id="faq-answer-ceb" rows="2"></textarea>
                  </div>
                </div>
                <div class="box-footer">
                  <button type="submit" class="btn btn-success">Save FAQ</button>
                  <button type="button" id="faq-reset" class="btn btn-default">Reset</button>
                </div>
              </form>
            </div>
          </div>
          <div class="col-md-6">
            <div class="box box-solid">
              <div class="box-header with-border"><h3 class="box-title">Existing FAQs (config + custom)</h3></div>
              <div class="box-body table-responsive no-padding" style="max-height: 420px; overflow:auto;">
                <table class="table table-striped table-bordered">
                  <thead>
                    <tr><th>ID</th><th>Patterns</th><th>Answer</th><th>Actions</th></tr>
                  </thead>
                  <tbody>
                    @foreach($faqs as $f)
                      <tr>
                        <td>{{ $f['id'] ?? '' }}</td>
                        <td style="max-width: 220px; white-space: nowrap; overflow: hidden; text-overflow: ellipsis;" title="{{ implode(', ', (array)($f['patterns'] ?? [])) }}">
                          {{ implode(', ', (array)($f['patterns'] ?? [])) }}
                        </td>
                        <td style="max-width: 280px; white-space: nowrap; overflow: hidden; text-overflow: ellipsis;" title="{{ $f['answer'] ?? '' }}">
                          {{ $f['answer'] ?? '' }}
                        </td>
                        <td>
                          <button type="button" class="btn btn-xs btn-primary js-faq-edit" data-id="{{ $f['id'] ?? '' }}">Edit</button>
                          <form method="POST" action="{{ route('ai.faq.delete') }}" style="display:inline;" class="js-faq-del-form">
                            @csrf
                            <input type="hidden" name="id" value="{{ $f['id'] ?? '' }}">
                            <button type="submit" class="btn btn-xs btn-danger js-faq-del" data-id="{{ $f['id'] ?? '' }}" onclick="return confirm('Delete this FAQ? This cannot be undone.');">Delete</button>
                          </form>
                        </td>
                      </tr>
                    @endforeach
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>

      <div class="tab-pane" id="tab_products">
        <div class="box box-solid">
          <div class="box-header with-border"><h3 class="box-title">Sync Products Snapshot for AI</h3></div>
          <div class="box-body">
            <p>This generates a lightweight product list (name, SKU, price, quantities per location) the AI can reference when answering product questions.</p>
          </div>
          <div class="box-footer">
            <form method="POST" action="{{ route('ai.sync.products') }}">@csrf
              <button type="submit" class="btn btn-primary">Sync Products</button>
            </form>
          </div>
        </div>
      </div>

      <div class="tab-pane" id="tab_reports">
        <div class="box box-solid">
          <div class="box-header with-border"><h3 class="box-title">Precompute Key Report Answers</h3></div>
          <div class="box-body">
            <p>Cache sales and purchase totals for common time ranges (Today, This Week, This Month, Last Month, This Year, Last Year) so the AI answers instantly.</p>
          </div>
          <div class="box-footer">
            <form method="POST" action="{{ route('ai.train.reports') }}">@csrf
              <button type="submit" class="btn btn-warning">Train from Reports</button>
            </form>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<script>
(function(){
  function qs(id){ return document.getElementById(id); }
  function setForm(faq){
    qs('faq-id').value = faq.id || '';
    qs('faq-patterns').value = (faq.patterns||[]).join(', ');
    qs('faq-answer').value = faq.answer||'';
    const tr = faq.answer_translations||{};
    qs('faq-answer-tl').value = tr.tl||'';
    qs('faq-answer-ceb').value = tr.ceb||'';
  }
  document.querySelectorAll('.js-faq-edit').forEach(btn=>{
    btn.addEventListener('click', async ()=>{
      const id = btn.getAttribute('data-id');
      try{
        const r = await fetch("{{ url('/ai-chat/faqs') }}/"+encodeURIComponent(id));
        const d = await r.json();
        if(d && d.ok && d.faq){ setForm(d.faq); window.scrollTo({ top: 0, behavior: 'smooth' }); }
        else{ alert('FAQ not found.'); }
      }catch(e){ alert('Failed to load FAQ'); }
    });
  });
  document.getElementById('faq-reset')?.addEventListener('click', ()=>{
    setForm({ id:'', patterns:[], answer:'', answer_translations:{} });
  });
})();
</script>
@stop
@push('scripts')
<script>
(function(){
  const token = (document.querySelector('meta[name="csrf-token"]')||{}).getAttribute?.('content');
  function qs(id){ return document.getElementById(id); }
  function setForm(faq){
    qs('faq-id').value = faq.id || '';
    qs('faq-patterns').value = (faq.patterns||[]).join(', ');
    qs('faq-answer').value = faq.answer||'';
    const tr = faq.answer_translations||{};
    qs('faq-answer-tl').value = tr.tl||'';
    qs('faq-answer-ceb').value = tr.ceb||'';
  }
  document.querySelectorAll('.js-faq-edit').forEach(btn=>{
    btn.addEventListener('click', async ()=>{
      const id = btn.getAttribute('data-id');
      try{
        const r = await fetch("{{ url('/ai-chat/faqs') }}/"+encodeURIComponent(id));
        const d = await r.json();
        if(d && d.ok){ setForm(d.faq||{}); }
        else{ alert('FAQ not found.'); }
      }catch(e){ alert('Failed to load FAQ'); }
    });
  });
  document.querySelectorAll('.js-faq-del-form').forEach(frm=>{
    frm.addEventListener('submit', (e)=>{
      if(!confirm('Delete this FAQ? This cannot be undone.')){ e.preventDefault(); }
    });
  });
  qs('faq-reset')?.addEventListener('click', ()=>{
    setForm({ id:'', patterns:[], answer:'', answer_translations:{} });
  });
})();
</script>
@endpush
